package com.kuaike.skynet.manager.wechat.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@Data
public class BizAddReq implements Serializable {

    private static final long serialVersionUID = 1223856548927238742L;

    private Long bizId;  // 商户id

    private String bizName;    // 商户名称

    private Long orgId; //部门ID

    private Long adminUserId; // admin账户ID

    private Long sysUserId; //内置账户ID

    public void validate(){
        Preconditions.checkArgument(Objects.nonNull(bizId),"商户ID不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(bizName),"商户名不能为空");
        Preconditions.checkArgument(Objects.nonNull(orgId),"部门ID不能为空");
        Preconditions.checkArgument(Objects.nonNull(adminUserId),"admin账户ID不能为空");
        Preconditions.checkArgument(Objects.nonNull(sysUserId),"内置账户ID不能为空");
    }

}
