/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponCreateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetUserListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponPushReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponUpdateStatusReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponCreateResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetListResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetUserListResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopCouponAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopCouponAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.coupon.create}")
    private String shopCouponCreateUrl;
    @Value(value="${wx.shop.coupon.update}")
    private String shopCouponUpdateUrl;
    @Value(value="${wx.shop.coupon.update_status}")
    private String shopCouponUpdateStatusUrl;
    @Value(value="${wx.shop.coupon.get}")
    private String shopCouponGetUrl;
    @Value(value="${wx.shop.coupon.get_list}")
    private String shopCouponGetListUrl;
    @Value(value="${wx.shop.coupon.push}")
    private String shopCouponPushUrl;
    @Value(value="${wx.shop.coupon.get_user}")
    private String shopCouponGetUserUrl;

    public CouponCreateResp createCoupon(@NonNull String accessToken, @NonNull CouponCreateReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("createCoupon with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponCreateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CouponCreateResp.class, new Object[0]);
        CouponCreateResp result = (CouponCreateResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CouponCreateResp updateCoupon(@NonNull String accessToken, @NonNull CouponCreateReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("updateCoupon with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponUpdateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CouponCreateResp.class, new Object[0]);
        CouponCreateResp result = (CouponCreateResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode updateCouponStatus(@NonNull String accessToken, @NonNull CouponUpdateStatusReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("updateCouponStatus with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponUpdateStatusUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CouponGetResp getCoupon(@NonNull String accessToken, @NonNull CouponGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getCoupon with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CouponGetResp.class, new Object[0]);
        CouponGetResp result = (CouponGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CouponGetListResp getCouponList(@NonNull String accessToken, @NonNull CouponGetListReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getCouponList with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponGetListUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CouponGetListResp.class, new Object[0]);
        CouponGetListResp result = (CouponGetListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode pushCoupon(@NonNull String accessToken, @NonNull CouponPushReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("pushCoupon with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponPushUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CouponGetUserListResp getCouponUserList(@NonNull String accessToken, @NonNull CouponGetUserListReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getCouponUserList with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopCouponGetUserUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CouponGetUserListResp.class, new Object[0]);
        CouponGetUserListResp result = (CouponGetUserListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

