/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsUserinfo;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class WxOAuth2API {
    private static final Logger log = LoggerFactory.getLogger(WxOAuth2API.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.oauth2.get_code}")
    private String wxOAuth2GetCode;
    @Value(value="${wx.component.oauth2.get_code}")
    private String wxComponentOAuth2GetCode;
    @Value(value="${wx.oauth2.access_token}")
    private String wxOAuth2AccessToken;
    @Value(value="${wx.component.oauth2.access_token}")
    private String wxComponentOauth2AccessToken;
    @Value(value="${wx.oauth2.refresh_token}")
    private String wxOAuth2RefreshToken;
    @Value(value="${wx.oauth2.auth}")
    private String wxOAuth2Auth;
    @Value(value="${wx.oauth2.user_info}")
    private String wxOAuth2Userinfo;
    @Value(value="${wx.connect.qrconnect}")
    private String wxConnectQrconnect;

    public String getOauthPageUrl(@NonNull String appId, @NonNull String redirectUrl, @NonNull String scope, String state) {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        log.info("generate oauth page url with appId={}, scope={}, state={}", new Object[]{appId, scope, state});
        String wxUrl = MessageFormat.format(this.wxOAuth2GetCode, appId, redirectUrl, scope, state);
        return wxUrl;
    }

    public String getComponentOauthPageUrl(@NonNull String appId, @NonNull String redirectUrl, @NonNull String scope, String state, @NonNull String componentAppId) {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (componentAppId == null) {
            throw new NullPointerException("componentAppId is marked non-null but is null");
        }
        log.info("generate oauth page url with appId={}, scope={}, state={}, redirectUrl={}", new Object[]{appId, scope, state, redirectUrl});
        String wxUrl = MessageFormat.format(this.wxComponentOAuth2GetCode, appId, redirectUrl, scope, state, componentAppId);
        log.info("login page url{}", (Object)wxUrl);
        return wxUrl;
    }

    public SnsAccessToken accessToken(@NonNull String appId, @NonNull String appSecret, @NonNull String code) throws WeixinException {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (appSecret == null) {
            throw new NullPointerException("appSecret is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        log.info("get sns access token with code={}", (Object)code);
        String url = MessageFormat.format(this.wxOAuth2AccessToken, appId, appSecret, code);
        ResponseEntity response = this.restTemplate.getForEntity(url, SnsAccessToken.class, new Object[0]);
        SnsAccessToken result = (SnsAccessToken)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SnsAccessToken getComponentAccessToken(@NonNull String appId, @NonNull String code, @NonNull String componentAppId, @NonNull String componentToken) throws WeixinException {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (componentAppId == null) {
            throw new NullPointerException("componentAppId is marked non-null but is null");
        }
        if (componentToken == null) {
            throw new NullPointerException("componentToken is marked non-null but is null");
        }
        log.info("get sns access token with code={}", (Object)code);
        String url = MessageFormat.format(this.wxComponentOauth2AccessToken, appId, code, componentAppId, componentToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, SnsAccessToken.class, new Object[0]);
        SnsAccessToken result = (SnsAccessToken)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SnsAccessToken refressToken(@NonNull String appId, @NonNull String refreshToken) throws WeixinException {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        log.info("refresh token.");
        String url = MessageFormat.format(this.wxOAuth2RefreshToken, appId, refreshToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, SnsAccessToken.class, new Object[0]);
        SnsAccessToken result = (SnsAccessToken)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public boolean auth(@NonNull String accessToken, @NonNull String openId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        log.info("auth with openId={}", (Object)openId);
        String url = MessageFormat.format(this.wxOAuth2Auth, accessToken, openId);
        ResponseEntity response = this.restTemplate.getForEntity(url, ErrorCode.class, new Object[0]);
        return WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public SnsUserinfo getUserinfo(@NonNull String accessToken, @NonNull String openId, @NonNull String lang) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        log.info("get sns userinfo with openId={}", (Object)openId);
        String url = MessageFormat.format(this.wxOAuth2Userinfo, accessToken, openId, lang);
        ResponseEntity response = this.restTemplate.getForEntity(url, SnsUserinfo.class, new Object[0]);
        SnsUserinfo result = (SnsUserinfo)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public String getQrConnectUrl(@NonNull String appId, @NonNull String redirectUrl, @NonNull String scope, String state) {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        log.info("getQrConnectUrl with appId={}, scope={}, state={}", new Object[]{appId, scope, state});
        return MessageFormat.format(this.wxConnectQrconnect, appId, redirectUrl, scope, state);
    }
}

