/**
 * 对公众平台发送给公众账号的消息加解密示例代码.
 * 
 * @copyright Copyright (c) 1998-2014 Tencent Inc.
 */

// ------------------------------------------------------------------------

package cn.kinyun.scrm.weixin.sdk.utils.aes;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * SHA1 class
 *
 * 计算公众平台的消息签名接口.
 */
public class SHA1 {

    /**
     * 用SHA1算法生成安全签名
     * 
     * @param token 票据
     * @param timestamp 时间戳
     * @param nonce 随机字符串
     * @param encrypt 密文
     * @return 安全签名
     * @throws AesException
     */
    public static String getSHA1(String token, String timestamp, String nonce, String encrypt) throws AesException {
        String[] array = new String[] { token, timestamp, nonce, encrypt };
        StringBuffer sb = new StringBuffer();
        // 字符串排序
        Arrays.sort(array);
        for (int i = 0; i < 4; i++) {
            sb.append(array[i]);
        }
        String str = sb.toString();

        return sha1(str);
    }

    /**
     * 校验请求内容是否来自微信
     * 
     * @param token
     * @param signature
     * @param timestamp
     * @param nonce
     * @return
     */
    public static boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        String[] arr = new String[]{token, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < 3; i++) {
            content.append(arr[i]);
        }

        try {
            String str = sha1(content.toString());
            return str.equalsIgnoreCase(signature);
        } catch (AesException e) {
            ;
            return false;
        }
    }

    /**
     * 生成SHA1签名
     * 
     * @param str
     * @return
     * @throws AesException
     */
    public static String sha1(String str) throws AesException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            digest = md.digest();
        } catch (NoSuchAlgorithmException e) {
            
            throw new AesException(AesException.COMPUTE_SIGNATURE_ERROR);
        }

        // 把密文转换成十六进制的字符串形式
        return toHexStr(digest);
    }

    // 十六进制数
    private static final char[] HEX_DIGITS =
        { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

    // 把密文转换成十六进制的字符串形式
    public static String toHexStr(byte[] digest) {
        char[] value = new char[digest.length * 2];
        for (int i = 0, idx = 0; i < digest.length; i++, idx += 2) {
            value[idx] = (HEX_DIGITS[(digest[i] >> 4) & 0x0F]); // 前四位
            value[idx + 1] = (HEX_DIGITS[digest[i] & 0x0F]); // 后四位
        }
        return new String(value);
    }
}