package cn.kinyun.scrm.weixin.sdk.entity.user.req;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.entity.user.req
 * @date Date : 2019年04月26日 17:54
 */
@Data
public class BatchUserInfoReq implements Serializable {

    private static final long serialVersionUID = -7890012576413671526L;

    @JsonProperty("user_list")
    private List<UserInfoReq> userList;

    @Data
    @NoArgsConstructor
    public class UserInfoReq implements Serializable {

        private static final long serialVersionUID = 1130447530174046391L;

        /**
         * 用户标识，当前公众号唯一
         */
        @JsonProperty("openid")
        private String openId;

        /**
         * 国家地区语言版本，zh_CN 简体，zh_TW 繁体，en 英语，默认为zh-CN（非必传）
         */
        private String lang;

        public UserInfoReq(String openId) {
            this.openId = openId;
        }
    }

}
