/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 设置行业信息
 * 
 * @title SetIndustry
 * @desc 行业信息
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
public class SetIndustry implements Serializable {

    private static final long serialVersionUID = 7303259738264043345L;

    /**
     * 公众号模板消息所属主营行业编号
     */
    @JsonProperty("industry_id1")
    private String industryId1;

    /**
     * 公众号模板消息所属副营行业编号
     */
    @JsonProperty("industry_id2")
    private String industryId2;
}
