package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhangjing
 * @date 2022/1/4 2:57 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SkuUpdatePriceReq extends SkuIdReq{

    /**
     * 必填, 售卖价格，以分为单位，不超过1000000000（1000万元）
     */
    @JsonProperty("sale_price")
    private Long salePrice;

    /**
     * 非必填, 市场价格，以分为单位，不超过1000000000（1000万元），必须比sale_price大
     */
    @JsonProperty("market_price")
    private Long marketPrice;

}
