package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/30 4:19 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class RegisterShopReq {

    /**
     * 微信号, 必填
     */
    @JsonProperty("wx_name")
    private String wxName;

    /**
     * 身份证姓名, 必填
     */
    @JsonProperty("id_card_name")
    private String idCardName;

    /**
     * 身份证号, 必填
     */
    @JsonProperty("id_card_number")
    private String idCardNumber;

    /**
     * 渠道号, 非必填
     */
    @JsonProperty("channel_id")
    private String channelId;

    /**
     * 1-整店打包（开通小商店），2-组件开放（开通小程序，并且已经完整的嵌入电商功能）, 必填
     */
    @JsonProperty("api_openstore_type")
    private Integer apiOpenStoreType;

    /**
     * 授权页url, 非必填
     */
    @JsonProperty("auth_page_url")
    private String authPageUrl;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(wxName), "wxName不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(idCardName), "idCardName不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(idCardNumber), "idCardNumber不能为空");
        Preconditions.checkArgument(Objects.nonNull(apiOpenStoreType) && apiOpenStoreType >= 1 && apiOpenStoreType <= 2, "apiOpenStoreTypebu'en不能为空,且取值为[1,2]");
    }

}
