package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Created by chenjiaqiang on 2022/01/18
 **/
@Data
public class ModifyHeadImageReq {

    @JsonProperty("head_img_media_id")
    private String headImgMediaId;

    @JsonProperty("x1")
    private String x1;

    @JsonProperty("y1")
    private String y1;

    @JsonProperty("x2")
    private String x2;

    @JsonProperty("y2")
    private String y2;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNoneBlank(headImgMediaId),"headImgMediaId不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(x1),"x1不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(y1),"y1不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(x2),"x2不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(y2),"y2不能为空");
    }
}
