/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.req;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 地理位置消息
 * 
 * @title LocationReqMsg
 * @desc 地理位置消息
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper=true)
public class LocationReqMsg extends BaseReqMsg {

    private static final long serialVersionUID = -6109763867481726527L;

    /**
     * 地理位置维度
     */
    @JacksonXmlProperty(localName = "Location_X")
    private double locationX;

    /**
     * 地理位置经度
     */
    @JacksonXmlProperty(localName = "Location_Y")
    private double locationY;

    /**
     * 地图缩放大小
     */
    @JacksonXmlProperty(localName = "Scale")
    private int scale;

    /**
     * 地理位置信息
     */
    @JacksonXmlProperty(localName = "Label")
    private String label;
}