/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 扫描带参数二维码事件
 * 
 * <p>用户扫描带场景值二维码时，可能推送以下两种事件：</p>
 * <ul>
 * <li>如果用户还未关注公众号，则用户可以关注公众号，关注后微信会将带场景值关注事件推送给开发者。</li>
 * <li>如果用户已经关注公众号，则微信会将带场景值扫描事件推送给开发者。</li>
 * </ul>
 * 
 * @title ScanEvent
 * @desc 扫描带参数二维码事件
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class ScanEvent extends BaseEvent {

    private static final long serialVersionUID = -5335081162786739830L;

    /**
     * 事件KEY值，是一个32位无符号整数，即创建二维码时的二维码scene_id
     */
    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 二维码的ticket，可用来换取二维码图片
     */
    @JacksonXmlProperty(localName = "Ticket")
    private String ticket;
}