/*
 * 微信公众平台(JAVA) SDK
 *
 * Copyright (c) 2014, Ansitech Network Technology Co.,Ltd All rights reserved.
 * 
 * http://www.weixin4j.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package cn.kinyun.scrm.weixin.sdk.entity.media;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.io.ByteArrayInputStream;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 临时素材的附件
 * 
 * @title Attachment
 * @author yanmaoyuan
 * @date 2019年6月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Attachment extends ErrorCode {

    private static final long serialVersionUID = -168542869012684761L;

    private String fileName;

    private String contentLength;

    private String contentType;

    private ByteArrayInputStream inputStream;

}