package cn.kinyun.scrm.weixin.sdk.entity.material.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;

/**
 * @ClassName ArticleDto
 * @Description
 * @Author zhangjing
 * @DATE 2019/4/29 13:42
 * @Version 1.0
 */
@Data
public class ArticleDto {

    /**
     * 标题
     * 必填
     */
    private String title;
    
    /**
     * 图文消息的封面图片素材id（必须是永久mediaID）
     * 必填
     */
    @JsonProperty("thumb_media_id")
    private String thumbMediaId;
    
    /**
     * 作者
     *
     */
    private String author;

    /**
     * 图文消息的摘要，仅有单图文消息才有摘要，多图文此处为空。如果本字段为没有填写，则默认抓取正文前64个字。
     *
     */
    private String digest;

    /**
     * 是否显示封面，0为false，即不显示，1为true，即显示
     * 必填
     */
    @JsonProperty("show_cover_pic")
    private Integer showCoverPic;

    /**
     * 图文消息的具体内容，支持HTML标签，必须少于2万字符，小于1M，且此处会去除JS,涉及图片url必须来源 "上传图文消息内的图片获取URL"接口获取。外部图片url将被过滤。
     * 必填
     */
    private String content;

    /**
     * 图文链接
     */
    private String url;

    /**
     * 图文消息的原文地址，即点击“阅读原文”后的URL
     * 必填
     */
    @JsonProperty("content_source_url")
    private String contentSourceUrl;

    /**
     * Uint32 是否打开评论，0不打开，1打开
     */
    @JsonProperty("need_open_comment")
    private Integer needOpenComment;

    /**
     * Uint32 是否粉丝才可评论，0所有人可评论，1粉丝才可评论
     */
    @JsonProperty("only_fans_can_comment")
    private Integer onlyFansCanComment;
}
