/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.basic;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 公众号临时票据，可用于jsapi和wxcard
 * 
 * @title Ticket
 * @desc 公众号临时票据，可用于jsapi和wxcard
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Ticket extends ErrorCode {

    private static final long serialVersionUID = 4444274021388389426L;

    /**
     * 票据
     */
    private String ticket;

    /**
     * 有效期，默认7200秒
     */
    @JsonProperty("expires_in")
    private int expires = 7200;
}