package cn.kinyun.scrm.weixin.sdk.entity.applet;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author sunwen
 */
@Data
public class QrcodeCreateReq {

    /**
     * 最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~
     */
    private String scene;

    /**
     * 默认是主页，页面 page
     */
    private String page;

    /**
     * 默认是true，检查page 是否存在，为 true 时 page 必须是已经发布的小程序存在的页面（否则报错）；
     * 为 false 时允许小程序未发布或者 page 不存在
     */
    @JsonProperty("check_path")
    private Boolean checkPath = false;

    /**
     * 要打开的小程序版本。正式版为 "release"，体验版为 "trial"，开发版为 "develop"。默认是正式版
     */
    @JsonProperty("env_version")
    private String envVersion;

    /**
     * 默认430，二维码的宽度，单位 px，最小 280px，最大 1280px
     */
    private Integer width = 280;

    @JsonProperty("auto_color")
    private Boolean autoColor = false;
}
