/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.exception;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import java.util.ResourceBundle;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class WeixinException
extends RuntimeException {
    private static final long serialVersionUID = 3738216579645492071L;
    private static final String MESSAGE_FORMAT = "error(%d):%s";
    private static final String DEFAULT_ERROR_MESSAGE = "\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u3002";
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("message.WeixinErrorCode");
    private Integer errorCode;
    private String errorMsg;

    public static String getErrorMsg(Integer errorCode) {
        try {
            return RESOURCE_BUNDLE.getString(String.valueOf(errorCode));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isSuccess(@NonNull Integer errorCode) throws WeixinException {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        return WeixinException.isSuccess(errorCode, DEFAULT_ERROR_MESSAGE);
    }

    public static boolean isSuccess(@NonNull ErrorCode error) throws WeixinException {
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        return WeixinException.isSuccess(error.getErrCode(), error.getErrMsg());
    }

    public static boolean isSuccess(Integer errorCode, String defaultErrorMsg) throws WeixinException {
        if (errorCode == null || errorCode == 0) {
            return true;
        }
        String errorMsg = WeixinException.getErrorMsg(errorCode);
        if (errorMsg == null) {
            errorMsg = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{defaultErrorMsg}) ? defaultErrorMsg : DEFAULT_ERROR_MESSAGE;
        }
        throw new WeixinException(errorCode, errorMsg);
    }

    public WeixinException(Integer errorCode, String errorMsg) {
        super(String.format(MESSAGE_FORMAT, errorCode, errorMsg));
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

