/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.utils.MsgXmlBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;

public class TextMsg
extends BaseRespMsg {
    private static final long serialVersionUID = 2896171843831253400L;
    @JsonIgnore
    private StringBuffer contentBuilder = new StringBuffer();

    public TextMsg() {
        this.msgType = WxMsgType.Text.getValue();
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.contentBuilder.toString();
    }

    public void setContent(String content) {
        this.contentBuilder = new StringBuffer(content);
    }

    public TextMsg print(String content) {
        if (content != null) {
            this.contentBuilder.append(content);
        }
        return this;
    }

    public TextMsg println(String content) {
        if (content != null) {
            this.contentBuilder.append(content);
        }
        this.contentBuilder.append('\n');
        return this;
    }

    public TextMsg println() {
        this.contentBuilder.append('\n');
        return this;
    }

    public TextMsg printf(String format, Object ... args) {
        String content = String.format(format, args);
        this.contentBuilder.append(content);
        return this;
    }

    public TextMsg addHyperlink(@NonNull String title, @NonNull String url) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.contentBuilder.append("<a href=\"").append(url).append("\">");
        this.contentBuilder.append(title);
        this.contentBuilder.append("</a>");
        return this;
    }

    public TextMsg addMiniProgram(@NonNull String title, @NonNull String appId, @NonNull String appPath, String url) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (appPath == null) {
            throw new NullPointerException("appPath is marked non-null but is null");
        }
        this.contentBuilder.append("<a");
        this.contentBuilder.append(" href=\"").append(url).append('\"');
        this.contentBuilder.append(" data-miniprogram-appid=\"").append(appId).append('\"');
        this.contentBuilder.append(" data-miniprogram-path=\"").append(appPath).append('\"');
        this.contentBuilder.append('>');
        this.contentBuilder.append(title);
        this.contentBuilder.append("</a>");
        return this;
    }

    @Override
    public String toXml() {
        MsgXmlBuilder builder = new MsgXmlBuilder(super.toXml());
        builder.addCData("Content", this.contentBuilder.toString());
        builder.surroundWith("xml");
        return builder.toString();
    }

    public StringBuffer getContentBuilder() {
        return this.contentBuilder;
    }

    @JsonIgnore
    public void setContentBuilder(StringBuffer contentBuilder) {
        this.contentBuilder = contentBuilder;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMsg)) {
            return false;
        }
        TextMsg other = (TextMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringBuffer this$contentBuilder = this.getContentBuilder();
        StringBuffer other$contentBuilder = other.getContentBuilder();
        return !(this$contentBuilder == null ? other$contentBuilder != null : !this$contentBuilder.equals(other$contentBuilder));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextMsg;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StringBuffer $contentBuilder = this.getContentBuilder();
        result = result * 59 + ($contentBuilder == null ? 43 : $contentBuilder.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TextMsg(super=" + super.toString() + ", contentBuilder=" + this.getContentBuilder() + ")";
    }
}

