/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.entity.menu.dto;

import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.MenuButtonBase;
import cn.kinyun.scrm.weixin.sdk.enums.menu.MenuButtonType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;

public class MenuButton
extends MenuButtonBase {
    @JsonProperty(value="type")
    String type;
    @JsonProperty(value="key")
    String key;
    @JsonProperty(value="url")
    String url;
    @JsonProperty(value="appid")
    String appId;
    @JsonProperty(value="media_id")
    String mediaId;
    private Long matId;
    @JsonProperty(value="pagepath")
    String pagePath;
    @JsonProperty(value="sub_button")
    List<MenuButton> subButton;
    String mediaType;

    private MenuButton(String type, String name, String key, String url, String appid, String media_id, String pagepath, List<MenuButton> sub_button) {
        super(name);
        this.type = type;
        this.key = key;
        this.url = url;
        this.appId = appid;
        this.mediaId = media_id;
        this.pagePath = pagepath;
        this.subButton = sub_button;
    }

    public static MenuButton buildClickButton(@NonNull String name, @NonNull String key) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.click.name(), name, key, null, null, null, null, null);
    }

    public static MenuButton buildViewButton(@NonNull String name, @NonNull String url) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.view.name(), name, null, url, null, null, null, null);
    }

    public static MenuButton buildMiniProgramButton(@NonNull String name, @NonNull String url, @NonNull String appid, @NonNull String pagePath) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (appid == null) {
            throw new NullPointerException("appid is marked non-null but is null");
        }
        if (pagePath == null) {
            throw new NullPointerException("pagePath is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.miniprogram.name(), name, null, url, appid, null, pagePath, null);
    }

    public static MenuButton buildScancodeWaitMsgButton(@NonNull String name, @NonNull String key, List<MenuButton> subButton) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.scancode_waitmsg.name(), name, key, null, null, null, null, subButton);
    }

    public static MenuButton buildScancodePushButton(@NonNull String name, @NonNull String key, List<MenuButton> subButton) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.scancode_push.name(), name, key, null, null, null, null, subButton);
    }

    public static MenuButton buildPicSysphotoButton(@NonNull String name, @NonNull String key, List<MenuButton> subButton) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.pic_sysphoto.name(), name, key, null, null, null, null, subButton);
    }

    public static MenuButton buildPicPhotoOrAlbumButton(@NonNull String name, @NonNull String key, List<MenuButton> subButton) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.pic_photo_or_album.name(), name, key, null, null, null, null, subButton);
    }

    public static MenuButton buildPicWeiXinButton(@NonNull String name, @NonNull String key, List<MenuButton> subButton) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.pic_weixin.name(), name, key, null, null, null, null, subButton);
    }

    public static MenuButton buildLocationSelectButton(@NonNull String name, @NonNull String key) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.location_select.name(), name, key, null, null, null, null, null);
    }

    public static MenuButton buildMediaId(@NonNull String name, @NonNull String mediaId) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.media_id.name(), name, null, null, null, mediaId, null, null);
    }

    public static MenuButton buildViewLimited(@NonNull String name, @NonNull String mediaId) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        return new MenuButton(MenuButtonType.view_limited.name(), name, null, null, null, mediaId, null, null);
    }

    public static MenuButton buildTopLevelButton(@NonNull String name, List<MenuButton> subButton) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new MenuButton(null, name, null, null, null, null, null, subButton);
    }

    public String toJsonStr() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String json = null;
        try {
            json = objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return json;
    }

    public static void main(String[] args) {
        MenuButton button = MenuButton.buildClickButton("aaaa", "wqer");
        System.out.println(button.toJsonStr());
        MenuButton button1 = MenuButton.buildScancodePushButton("dsfs", "fdsfs", Lists.newArrayList());
        System.out.println(button1.toJsonStr());
        String json = "{\"type\":\"scancodePush\",\"mediaId\":\"mediaaaa\",\"name\":\"dsfs\",\"key\":\"fdsfs\",\"aaa\":[]}";
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MenuButton button2 = null;
        try {
            button2 = (MenuButton)objectMapper.readValue(json, MenuButton.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(button2);
    }

    public MenuButton() {
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public Long getMatId() {
        return this.matId;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public List<MenuButton> getSubButton() {
        return this.subButton;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="appid")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="media_id")
    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setMatId(Long matId) {
        this.matId = matId;
    }

    @JsonProperty(value="pagepath")
    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    @JsonProperty(value="sub_button")
    public void setSubButton(List<MenuButton> subButton) {
        this.subButton = subButton;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuButton)) {
            return false;
        }
        MenuButton other = (MenuButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$matId = this.getMatId();
        Long other$matId = other.getMatId();
        if (this$matId == null ? other$matId != null : !((Object)this$matId).equals(other$matId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$pagePath = this.getPagePath();
        String other$pagePath = other.getPagePath();
        if (this$pagePath == null ? other$pagePath != null : !this$pagePath.equals(other$pagePath)) {
            return false;
        }
        List<MenuButton> this$subButton = this.getSubButton();
        List<MenuButton> other$subButton = other.getSubButton();
        if (this$subButton == null ? other$subButton != null : !((Object)this$subButton).equals(other$subButton)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        return !(this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MenuButton;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $matId = this.getMatId();
        result = result * 59 + ($matId == null ? 43 : ((Object)$matId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $pagePath = this.getPagePath();
        result = result * 59 + ($pagePath == null ? 43 : $pagePath.hashCode());
        List<MenuButton> $subButton = this.getSubButton();
        result = result * 59 + ($subButton == null ? 43 : ((Object)$subButton).hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MenuButton(super=" + super.toString() + ", type=" + this.getType() + ", key=" + this.getKey() + ", url=" + this.getUrl() + ", appId=" + this.getAppId() + ", mediaId=" + this.getMediaId() + ", matId=" + this.getMatId() + ", pagePath=" + this.getPagePath() + ", subButton=" + this.getSubButton() + ", mediaType=" + this.getMediaType() + ")";
    }
}

