/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuAddReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuBatchAddReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuGetStockReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuIdReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuUpdatePriceReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuUpdateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuUpdateStockReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuAddResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuBatchAddResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuGetListResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuGetStockResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuUpdatePriceResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuUpdateResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuUpdateStockResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopSkuAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopSkuAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.sku.add}")
    private String shopSkuAddUrl;
    @Value(value="${wx.shop.sku.batch_add}")
    private String shopSkuBatchAddUrl;
    @Value(value="${wx.shop.sku.get}")
    private String shopSkuGetUrl;
    @Value(value="${wx.shop.sku.get_list}")
    private String shopSkuGetListUrl;
    @Value(value="${wx.shop.sku.del}")
    private String shopSkuDelUrl;
    @Value(value="${wx.shop.sku.update}")
    private String shopSkuUpdateUrl;
    @Value(value="${wx.shop.sku.update_price}")
    private String shopSkuUpdatePriceUrl;
    @Value(value="${wx.shop.stock.update}")
    private String shopStockUpdateUrl;
    @Value(value="${wx.shop.stock.get}")
    private String shopStockGetUrl;

    public SkuAddResp skuAdd(@NonNull String accessToken, @NonNull SkuAddReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuAdd with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuAddUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuAddResp.class, new Object[0]);
        SkuAddResp result = (SkuAddResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuBatchAddResp skuBatchAdd(@NonNull String accessToken, @NonNull SkuBatchAddReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuBatchAdd with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuBatchAddUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuBatchAddResp.class, new Object[0]);
        SkuBatchAddResp result = (SkuBatchAddResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode skuDel(@NonNull String accessToken, @NonNull SkuIdReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuDel with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuDelUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuGetResp skuGet(@NonNull String accessToken, @NonNull SkuGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuGet with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuGetResp.class, new Object[0]);
        SkuGetResp result = (SkuGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuGetListResp skuGetBatch(@NonNull String accessToken, @NonNull SkuGetListReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuGetBatch with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuGetListUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuGetListResp.class, new Object[0]);
        SkuGetListResp result = (SkuGetListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuUpdateResp skuUpdate(@NonNull String accessToken, @NonNull SkuUpdateReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuUpdate with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuUpdateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuUpdateResp.class, new Object[0]);
        SkuUpdateResp result = (SkuUpdateResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuUpdatePriceResp skuUpdatePrice(@NonNull String accessToken, @NonNull SkuUpdatePriceReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuUpdatePrice with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSkuUpdatePriceUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuUpdatePriceResp.class, new Object[0]);
        SkuUpdatePriceResp result = (SkuUpdatePriceResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuUpdateStockResp skuUpdateStock(@NonNull String accessToken, @NonNull SkuUpdateStockReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuUpdateStock with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopStockUpdateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuUpdateStockResp.class, new Object[0]);
        SkuUpdateStockResp result = (SkuUpdateStockResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SkuGetStockResp skuGetStock(@NonNull String accessToken, @NonNull SkuGetStockReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("skuGetStock with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopStockGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SkuGetStockResp.class, new Object[0]);
        SkuGetStockResp result = (SkuGetStockResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

