/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.component;

import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizeMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.BaseMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.TicketMsg;
import cn.kinyun.scrm.weixin.sdk.enums.component.InfoType;
import cn.kinyun.scrm.weixin.sdk.utils.aes.WXBizMsgCrypt;
import cn.kinyun.scrm.weixin.sdk.utils.aes.XMLParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;

public class ComponentMsgAPI {
    public static BaseMsg praseMsg(@NonNull HttpServletRequest request, @NonNull String token, @NonNull String encodingAesKey, @NonNull String appId) throws Exception {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (encodingAesKey == null) {
            throw new NullPointerException("encodingAesKey is marked non-null but is null");
        }
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        String msgSignature = request.getParameter("msg_signature");
        String timeStamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String postData = sb.toString();
            WXBizMsgCrypt wxBizMsgCrypt = new WXBizMsgCrypt(token, encodingAesKey, appId);
            String xmlText = wxBizMsgCrypt.decryptMsg(msgSignature, timeStamp, nonce, postData);
            Map<String, String> baseMsgMap = XMLParser.xmlToMap(xmlText);
            BaseMsg baseMsg = new BaseMsg();
            baseMsg.setAppId(baseMsgMap.get("AppId"));
            baseMsg.setCreateTime(baseMsgMap.get("CreateTime"));
            baseMsg.setInfoType("InfoType");
            if (InfoType.component_verify_ticket.getType().equals(baseMsg.getInfoType())) {
                TicketMsg ticketMsg = ComponentMsgAPI.praseTicketMsg(xmlText, baseMsg);
                return ticketMsg;
            }
            if (InfoType.authorized.getType().equals(baseMsg.getInfoType())) {
                AuthorizeMsg authorizeMsg = ComponentMsgAPI.praseAuthorizeMsg(xmlText, baseMsg);
                return authorizeMsg;
            }
            if (InfoType.unauthorized.getType().equals(baseMsg.getInfoType())) {
                AuthorizeMsg authorizeMsg = ComponentMsgAPI.praseAuthorizeMsg(xmlText, baseMsg);
                return authorizeMsg;
            }
            if (InfoType.updateauthorized.getType().equals(baseMsg.getInfoType())) {
                AuthorizeMsg authorizeMsg = ComponentMsgAPI.praseAuthorizeMsg(xmlText, baseMsg);
                return authorizeMsg;
            }
            BaseMsg baseMsg2 = baseMsg;
            return baseMsg2;
        }
    }

    private static TicketMsg praseTicketMsg(String xmlText, BaseMsg baseMsg) throws Exception {
        Map<String, String> ticketMsgMap = XMLParser.xmlToMap(xmlText);
        TicketMsg ticketMsg = new TicketMsg();
        ticketMsg.setComponentVerifyTicket(ticketMsgMap.get("ComponentVerifyTicket"));
        ticketMsg.setAppId(baseMsg.getAppId());
        ticketMsg.setCreateTime(baseMsg.getCreateTime());
        ticketMsg.setInfoType(baseMsg.getInfoType());
        return ticketMsg;
    }

    private static AuthorizeMsg praseAuthorizeMsg(String xmlText, BaseMsg baseMsg) throws Exception {
        Map<String, String> authorizeMsgMap = XMLParser.xmlToMap(xmlText);
        AuthorizeMsg authorizeMsg = new AuthorizeMsg();
        authorizeMsg.setAppId(baseMsg.getAppId());
        authorizeMsg.setCreateTime(baseMsg.getCreateTime());
        authorizeMsg.setInfoType(baseMsg.getInfoType());
        authorizeMsg.setAuthorizerAppid(authorizeMsgMap.get("AuthorizerAppid"));
        authorizeMsg.setAuthorizationCode(authorizeMsgMap.get("AuthorizationCode"));
        authorizeMsg.setAuthorizationCodeExpiredTime(Long.parseLong(authorizeMsgMap.get("AuthorizationCodeExpiredTime")));
        authorizeMsg.setPreAuthCode(authorizeMsgMap.get("PreAuthCode"));
        return authorizeMsg;
    }
}

