/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.entity.material.resp.UploadImgResp;
import cn.kinyun.scrm.weixin.sdk.entity.media.Attachment;
import cn.kinyun.scrm.weixin.sdk.entity.media.MediaResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VideoMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.HttpsClient;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxMediaAPI {
    private static final Logger log = LoggerFactory.getLogger(WxMediaAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.media.uploadvideo}")
    private String wxMediaUploadVideo;
    @Value(value="${wx.media.uploadimg}")
    private String wxMediaUploadImg;
    @Value(value="${wx.media.upload}")
    private String wxMediaUpload;
    @Value(value="${wx.media.get}")
    private String wxMediaGet;
    @Value(value="${wx.media.get.jssdk}")
    private String wxMediaGetJssdk;

    public MediaResult uploadVideo(@NonNull String accessToken, @NonNull VideoMsg videoMsg) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (videoMsg == null) {
            throw new NullPointerException("videoMsg is marked non-null but is null");
        }
        log.info("upload video to get mpvideo. videoMsg={}", (Object)videoMsg);
        Preconditions.checkArgument((videoMsg.getMediaId() != null ? 1 : 0) != 0, (Object)"\u7d20\u6750ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{videoMsg.getTitle()}), (Object)"\u89c6\u9891\u6807\u9898\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{videoMsg.getDescription()}), (Object)"\u89c6\u9891\u63cf\u8ff0\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)videoMsg, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMediaUploadVideo, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, MediaResult.class, new Object[0]);
        MediaResult result = (MediaResult)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UploadImgResp uploadImg(@NonNull String accessToken, @NonNull File file) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)file.getName());
        HttpEntity httpEntity = new HttpEntity((Object)param);
        ResponseEntity resp = this.restTemplate.exchange(this.wxMediaUploadImg, HttpMethod.POST, httpEntity, UploadImgResp.class, new Object[]{accessToken});
        UploadImgResp result = (UploadImgResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public MediaResult upload(@NonNull String accessToken, @NonNull WxMediaType type, @NonNull File file) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)file.getName());
        HttpEntity httpEntity = new HttpEntity((Object)param);
        ResponseEntity resp = this.restTemplate.exchange(this.wxMediaUpload, HttpMethod.POST, httpEntity, MediaResult.class, new Object[]{accessToken, type.getValue()});
        MediaResult result = (MediaResult)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public Attachment get(@NonNull String accessToken, @NonNull String mediaId) throws WeixinException, IOException, GeneralSecurityException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wxMediaGet, accessToken, mediaId);
        HttpsClient client = new HttpsClient();
        Attachment result = client.downloadHttps(url);
        WeixinException.isSuccess(result);
        return result;
    }

    public Attachment getJssdk(@NonNull String accessToken, @NonNull String mediaId) throws WeixinException, IOException, GeneralSecurityException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wxMediaGetJssdk, accessToken, mediaId);
        HttpsClient client = new HttpsClient();
        Attachment result = client.downloadHttps(url);
        WeixinException.isSuccess(result);
        return result;
    }
}

