package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhangjing
 * @date 2022/1/4 3:33 下午
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class SkuUpdateStockReq extends SkuIdReq{
    /**
     * 必填, 1:全量更新 2:增量更新
     */
    private Integer type;
    /**
     * 必填, 全量更新时，stock_num必须大于0；增量更新时正数增加库存，负数减库存
     */
    @JsonProperty("stock_num")
    private Long stockNum;
}
