package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;

@Data
public class FundSubmitWithdrawReq {

    /**
     * 必填, 提现金额（单位：分）
     */
    private Long amount;

    /**
     * 非必填, 提现备注
     */
    private String remark;

    /**
     * 非必填, 银行附言
     */
    @JsonProperty("bank_memo")
    private String bankMemo;

    public void validate() {
        Preconditions.checkArgument(amount != null && amount.compareTo(0L) > 0, "amount提现金额必须大于0");
    }
}
