package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.fund;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class AccountInfo {

    /**
     * 必填, 账户类型
     */
    @JsonProperty("bank_account_type")
    private String bankAccountType;

    /**
     * 必填, 开户银行
     */
    @JsonProperty("account_bank")
    private String accountBank;

    /**
     * 必填, 开户银行省市编码（需至少精确到市）
     */
    @JsonProperty("bank_address_code")
    private String bankAddressCode;

    /**
     * 非必填, 开户银行联行号
     */
    @JsonProperty("bank_branch_id")
    private String bankBranchId;

    /**
     * 非必填, 开户银行全称（若开户银行为“其他银行”，则需二选一填写“开户银行全称（含支行）”或“开户银行联行号”)
     */
    @JsonProperty("bank_name")
    private String bankName;

    /**
     * 必填, 银行账号
     */
    @JsonProperty("account_number")
    private String accountNumber;

    /**
     * 非必填, 开户银行名称前端展示值（为空时默认用account_bank字段）
     */
    @JsonProperty("account_bank4show")
    private String accountBank4Show;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNoneBlank(bankAccountType), "bankAccountType不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(accountBank), "accountBank不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(bankAddressCode), "bankAddressCode不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(accountNumber), "accountNumber不能为空");
    }
}
