package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.aftersale;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 2:55 下午
 */
@Data
public class AfterSaleOrder {
    /**
     * 售后单号
     */
    @JsonAlias("order_id")
    private Long orderId;

    /**
     * 售后单状态
     *
     *     AFTERSALESTATUS_INVALID = 0;
     *     USER_CANCELD = 1; // 用户取消申请
     *     MERCHANT_PROCESSING = 2; // 商家受理中
     *     MERCHANT_REJECT_REFUND = 4; // 商家拒绝退款
     *     MERCHANT_REJECT_RETURN = 5; // 商家拒绝退货退款
     *     USER_WAIT_RETURN = 6; // 待买家退货
     *     RETURN_CLOSED = 7; // 退货退款关闭
     *     MERCHANT_WAIT_RECEIPT = 8; // 待商家收货
     *     MERCHANT_OVERDUE_REFUND = 12; // 商家逾期未退款
     *     MERCHANT_REFUND_SUCCESS = 13; // 退款完成
     *     MERCHANT_RETURN_SUCCESS = 14; // 退货退款完成
     *     PLATFORM_REFUNDING = 15; // 平台退款中
     *     PLATFORM_REFUND_FAIL = 16; // 平台退款失败
     *     USER_WAIT_CONFIRM = 17; // 待用户确认
     *     MERCHANT_REFUND_RETRY_FAIL = 18; // 商家打款失败，客服关闭售后
     *     MERCHANT_FAIL = 19; // 售后关闭
     */
    private String status;

    /**
     * 用户openid
     */
    @JsonAlias("openid")
    private String openId;

    /**
     * 售后单对应的订单号
     */
    @JsonAlias("original_order_id")
    private Long originalOrderId;

    @JsonAlias("product_info")
    private AfterSaleProductInfo productInfo;

    private DetailDto details;

    @JsonAlias("refund_info")
    private RefundInfo refundInfo;

    @JsonAlias("return_info")
    private ReturnInfo returnInfo;

    @JsonAlias("merchant_upload_info")
    private MerchantUploadInfo merchantUploadInfo;

    /**
     * 售后单创建时间, 单位秒
     */
    @JsonAlias("create_time")
    private Long createTime;

    /**
     * 售后单更新时间, 单位秒
     */
    @JsonAlias("update_time")
    private Long updateTime;

    /**
     * 退款原因
     *
     *     INCORRECT_SELECTION = 1; // 拍错/多拍
     *     NO_LONGER_WANT = 2; // 不想要了
     *     NO_EXPRESS_INFO = 3; // 无快递信息
     *     EMPTY_PACKAGE = 4; // 包裹为空
     *     REJECT_RECEIVE_PACKAGE = 5; // 已拒签包裹
     *     NOT_DELIVERED_TOO_LONG = 6; // 快递长时间未送达
     *     NOT_MATCH_PRODUCT_DESC = 7; // 与商品描述不符
     *     QUALITY_ISSUE = 8; // 质量问题
     *     SEND_WRONG_GOODS = 9; // 卖家发错货
     *     THREE_NO_PRODUCT = 10; // 三无产品
     *     FAKE_PRODUCT = 11; // 假冒产品
     *     OTHERS = 12; // 其它
     */
    private String reason;

    @JsonAlias("refund_resp")
    private RefundResp refundResp;

    /**
     * 退款方式
     *
     * REFUND = 1; // 退款
     * RETURN = 2; // 退货退款
     */
    private String type;
}
