package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/30 7:12 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class OrganizationCodeInfo {

    /**
     * 组织结构代码证图片
     */
    @JsonProperty("pic_file")
    private PicFile picFile;

    /**
     * 1、请填写组织机构代码证上的组织机构代码。
     * 2、可填写9或10位 数字\字母\连字符。示例值：12345679-A
     */
    @JsonProperty("organization_code")
    private String organizationCode;

    /**
     * 注册日期，格式：2014-01-01
     */
    @JsonProperty("start_date")
    private String startDate;

    /**
     * 结束有效期，格式：2014-01-01
     * 1、若证件有效期为长期，请填写：长期。
     * 2、结束时间需大于开始时间。
     * 3、有效期必须大于60天，即结束时间距当前时间需超过60天。
     */
    @JsonProperty("end_date")
    private String endDate;
}
