package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Created by chenjiaqiang on 2022/01/18
 **/
@Data
public class SetNicknameReq {

    @JsonProperty("nick_name")
    private String nickname;

    @JsonProperty("id_card")
    private String idCard;

    @JsonProperty("license")
    private String license;

    @JsonProperty("naming_other_stuff_1")
    private String namingOtherStuff1;

    @JsonProperty("naming_other_stuff_2")
    private String namingOtherStuff2;

    @JsonProperty("naming_other_stuff_3")
    private String namingOtherStuff3;

    @JsonProperty("naming_other_stuff_4")
    private String namingOtherStuff4;

    @JsonProperty("naming_other_stuff_5")
    private String namingOtherStuff5;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNoneBlank(nickname),"nickname不能为空");
    }
}
