/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.req;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 链接消息
 * 
 * @title LinkReqMsg
 * @desc 链接消息
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class LinkReqMsg extends BaseReqMsg {

    private static final long serialVersionUID = -4646402165365847043L;

    /**
     * 消息标题
     */
    @JacksonXmlProperty(localName = "Title")
    private String title;

    /**
     * 消息描述
     */
    @JacksonXmlProperty(localName = "Description")
    private String description;

    /**
     * 消息链接
     */
    @JacksonXmlProperty(localName = "Url")
    private String url;
}