/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event.job;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 原创版权校验结果
 * 
 * @title CopyrightCheckResult
 * @desc 原创版权校验结果
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
public class CopyrightCheckResult implements Serializable {

    private static final long serialVersionUID = 2377391154002580056L;

    /**
     * 群发文章数量
     */
    @JacksonXmlProperty(localName = "Count")
    private int count;

    /**
     * 群发文章的校验结果
     */
    @JacksonXmlElementWrapper(localName = "ResultList")
    @JacksonXmlProperty(localName = "item")
    private List<ArticleCheckResult> resultList;

    /**
     * 整体校验结果
     * 
     * 1-未被判为转载，可以群发，2-被判为转载，可以群发，3-被判为转载，不能群发
     */
    @JacksonXmlProperty(localName = "CheckState")
    private int checkState;
}