/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 取消关注事件
 * 
 * @title UnsubscribeEvent
 * @desc 关注/取消关注事件
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class UnsubscribeEvent extends BaseEvent {

    private static final long serialVersionUID = -6048398887340785181L;

    /**
     * 事件KEY值. 取消订阅时，eventKey是一个空字符串。
     */
    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;
}