package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 11:34 上午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class MiniProgramInfo {

    /**
     * 小程序配置的合法域名信息
     */
    @JsonProperty("network")
    private NetworkDto network;

    /**
     * 小程序配置的类目信息
     */
    @JsonProperty("categories")
    private List<CategoryItem> categories;


    @JsonProperty("visit_status")
    private Integer visitStatus;
}
