package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.component.api.entity
 * @Description: 第三方推送基本消息
 * @date Date : 2019年04月25日 09:34
 */
@JacksonXmlRootElement(localName = "xml")
@Data
public class BaseMsg implements Serializable {
    private static final long serialVersionUID = -5124808715492318798L;

    /**
     * 第三方平台appId
     */
    @JacksonXmlProperty(localName = "AppId")
    private String appId;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private String createTime;

    /**
     * 消息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;
}
