/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.RegisterShopReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SubmitBasicInfoReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SubmitMerchantInfoReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CheckAuditStatusResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopRegisterAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopRegisterAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.register.check_audit_status}")
    private String checkAuditStatusPost;
    @Value(value="${wx.shop.register.register_shop}")
    private String registerShopPost;
    @Value(value="${wx.shop.register.submit_merchantinfo}")
    private String submitMerchantInfoPost;
    @Value(value="${wx.shop.register.submit_basicinfo}")
    private String submitBasicInfoPost;

    public CheckAuditStatusResp checkAuditStatus(@NonNull String accessToken, @NonNull String wxName) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (wxName == null) {
            throw new NullPointerException("wxName is marked non-null but is null");
        }
        log.info("checkAuditStatus with wxName={}", (Object)wxName);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wxName}), (Object)"wxName\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("wx_name", wxName);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.checkAuditStatusPost, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CheckAuditStatusResp.class, new Object[0]);
        CheckAuditStatusResp result = (CheckAuditStatusResp)resp.getBody();
        log.info("checkAuditStatus result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode registerShop(@NonNull String componentAccessToken, @NonNull RegisterShopReq req) {
        if (componentAccessToken == null) {
            throw new NullPointerException("componentAccessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("registerShop with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)componentAccessToken), (Object)"componentAccessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.registerShopPost, componentAccessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        log.info("registerShop result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode submitMerchantInfo(@NonNull String accessToken, @NonNull SubmitMerchantInfoReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("submitMerchantInfo with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessToken), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.submitMerchantInfoPost, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        log.info("submitMerchantInfo result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode submitBasicinfo(@NonNull String accessToken, @NonNull SubmitBasicInfoReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("submitBasicinfo with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessToken), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.submitBasicInfoPost, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        log.info("submitBasicinfo result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }
}

