/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.analysis;

import cn.kinyun.scrm.weixin.sdk.entity.analysis.AnalysisReq;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.user.UserCumulate;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.user.UserSummary;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxUserAnalysisAPI {
    private static final Logger log = LoggerFactory.getLogger(WxUserAnalysisAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.analysis.getusersummary}")
    private String wxAnalysisGetUserSummary;
    @Value(value="${wx.analysis.getusercumulate}")
    private String wxAnalysisGetUserCumulate;

    public UserSummary getUserSummary(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get user summary with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUserSummary, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserSummary.class, new Object[0]);
        UserSummary result = (UserSummary)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserCumulate getUserCumulate(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get user cumulate with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUserCumulate, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserCumulate.class, new Object[0]);
        UserCumulate result = (UserCumulate)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

