/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.enums.custom;

/**
 * 客服输入状态
 * 
 * <p>
 * 开发者可通过调用“客服输入状态”接口，返回客服当前输入状态给用户。用户可以看到"对方正在输入..."
 * </p>
 * 
 * <p>
 * WARN:请不要修改这个枚举变量名的大小写
 * </p>
 * 
 * @title WxTypingStatus
 * @desc 客服输入状态
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 */
@SuppressWarnings("squid:S115")
public enum WxTypingStatus {

    /**
     * "Typing"：对用户下发“正在输入"状态
     */
    Typing,

    /**
     * "CancelTyping"：取消对用户的”正在输入"状态
     */
    CancelTyping;
}