package cn.kinyun.scrm.weixin.sdk.entity.shop.resp;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 8:02 下午
 */
@Data
public class FundGetWithdrawResp extends ErrorCode {

    /**
     * 金额
     */
    private Long amount;

    /**
     * 创建时间
     */
    @JsonAlias("create_time")
    private Long createTime;

    /**
     * 更新时间
     */
    @JsonAlias("update_time")
    private Long updateTime;

    /**
     * 失败原因
     */
    private String reason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 银行附言
     */
    @JsonAlias("bank_memo")
    private String bankMemo;

    /**
     * 银行名称
     */
    @JsonAlias("bank_name")
    private String bankName;

    /**
     * 银行账户
     */
    @JsonAlias("bank_num")
    private String bandNum;

    /**
     * 提现状态
     *
     * CREATE_SUCCESS	受理成功
     * SUCCESS	提现成功
     * FAIL	提现失败
     * REFUND	提现退票
     * CLOSE	关单
     * INIT	业务单已创建
     */
    private String status;
}
