package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Objects;

/**
 * @author zhangjing
 * @date 2022/1/4 10:22 上午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SpuListReq {

    /**
     * 必填, 商品状态
     */
    private Integer status;

    /**
     * 必填, 第几页(最小填1)
     */
    private Integer page;

    /**
     * 必填, 每页数量(不超过300)
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 默认0: 获取线上数据, 1:获取草稿数据
     */
    @JsonProperty("need_edit_spu")
    private Integer needEditSpu;

    /**
     * 默认1：小商店自营，2：AMS，4：联盟，8：推荐官推荐，16：闪电购
     */
    private Integer source;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(status), "status 不能为空");
        Preconditions.checkArgument(Objects.nonNull(page),"page不能为空");
        Preconditions.checkArgument(Objects.nonNull(pageSize),"pageSize不能为空");
    }
}
