package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/4 7:39 下午
 */
@Data
public class OrderSearchReq {

    /**
     * 非必填, 订单支付时间的搜索开始时间
     */
    @JsonProperty("start_pay_time")
    private String startPayTime;

    /**
     * 非必填, 订单支付时间的搜索结束时间
     */
    @JsonProperty("end_pay_time")
    private String endPayTime;

    /**
     * 非必填, 商品标题关键词
     */
    private String title;

    /**
     * 非必填, 商品编码
     */
    @JsonProperty("sku_code")
    private String skuCode;

    /**
     * 非必填, 收件人
     */
    @JsonProperty("user_name")
    private String userName;

    /**
     * 非必填, 收件人电话
     */
    @JsonProperty("tel_number")
    private String telNumber;

    /**
     * 非必填, 不填该参数:全部订单 0:没有正在售后的订单, 1:正在售后单数量大于等于1的订单
     */
    @JsonProperty("on_aftersale_order_exist")
    private Integer onAfterSaleOrderExist;

    /**
     * 非必填, 订单状态
     *
     * 10	待付款
     * 15	拼团活动 支付成功 等待成团中
     * 16	支付成功 等待商家接单中 (同城配送, 线下自提)
     * 17	支付成功待核销
     * 20	待发货
     * 21	部分发货
     * 30	待收货
     * 100	完成
     * 200	全部商品售后之后，订单取消
     * 250	用户主动取消或待付款超时取消
     */
    private Integer status;

    /**
     * 非必填, 订单来源，默认0, 1:小商店自营订单, 2:带货订单
     */
    private Integer source;

    /**
     * 非必填, 只搜一个订单时使用
     */
    @JsonProperty("order_id")
    private Long orderId;

    /**
     * 必填, 第几页（最小填1）
     */
    private Integer page;

    /**
     * 必填, 每页数量(不超过10,000)
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}
