package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/30 4:52 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class BusiLicense {

    /**
     * 营业执照类型 1:三证合一 2: 普通营业执照
     */
    @JsonProperty("license_type")
    private Integer licenseType;

    /**
     * 营业执照图片
     */
    @JsonProperty("pic_file")
    private PicFile picFile;

    /**
     * 请填写营业执照上的注册号/统一社会信用代码，
     * 须为15位数字或18位数字大写字母。
     * 示例值：123456789012345678 特殊规则：长度最小15个字节
     */
    @JsonProperty("registration_num")
    private String registrationNum;

    /**
     * 1、请填写营业执照/登记证书的商家名称，2~110个字符，支持括号
     * 2、个体工商户/党政、机关及事业单位，不能以“公司”结尾。
     * 3、个体工商户，若营业执照上商户名称为空或为“无”，请填写"个体户+经营者姓名"，
     * 如“个体户张三” 。示例值：腾讯科技有限公司
     */
    @JsonProperty("merchant_name")
    private String merchantName;

    /**
     * 请填写证件的经营者/法定代表人姓名。示例值：张三
     */
    @JsonProperty("legal_representative")
    private String legalRepresentative;

    /**
     * 注册地址
     */
    @JsonProperty("registered_addrs")
    private String registeredAddrs;

    /**
     * 注册日期，格式：2014-01-01
     */
    @JsonProperty("start_date")
    private String startDate;

    /**
     * 结束有效期，格式：2014-01-01
     * 1、若证件有效期为长期，请填写：长期。
     * 2、结束时间需大于开始时间。
     * 3、有效期必须大于60天，即结束时间距当前时间需超过60天。
     */
    @JsonProperty("end_date")
    private String endDate;
}
