/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import cn.kinyun.scrm.weixin.sdk.enums.custom.WxInviteStatus;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 微信客服账号
 * 
 * @title CustomAccount
 * @desc 微信客服账号
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
public class CustomAccount implements Serializable {

    private static final long serialVersionUID = 911863117892133313L;

    /**
     * 客服工号
     */
    @JsonProperty("kf_id")
    private String id;

    /**
     * 完整客服账号，格式为：账号前缀@公众号微信号
     */
    @JsonProperty("kf_account")
    private String account;

    /**
     * 客服昵称，最长6个汉字或12个英文字符。
     */
    @JsonProperty("nickname")
    @JsonAlias("kf_nick") // 在查询客服列表时，返回的昵称字段名为kf_nick
    private String nickname;

    /**
     * 客服账号登录密码，格式为密码明文的32位加密MD5值。
     * 
     * 该密码仅用于在公众平台官网的多客服功能中使用，若不使用多客服功能，则不必设置密码。
     * 
     * @deprecated 新版客服管理功能中，密码字段是不需要的。
     */
    @Deprecated
    private String password;

    /**
     * 客服头像
     */
    @JsonProperty("kf_headimgurl")
    private String headImg;

    /**
     * 如果客服帐号已绑定了客服人员微信号， 则此处显示微信号
     */
    @JsonProperty("kf_wx")
    private String wx;

    /**
     * 如果客服帐号尚未绑定微信号，但是已经发起了一个绑定邀请， 则此处显示绑定邀请的微信号
     */
    @JsonProperty("invite_wx")
    private String inviteWx;

    /**
     * 如果客服帐号尚未绑定微信号，但是已经发起过一个绑定邀请， 邀请的过期时间，为unix 时间戳
     */
    @JsonProperty("invite_expire_time")
    private int inviteExpireTime;

    /**
     * 邀请的状态，有等待确认“waiting”，被拒绝“rejected”， 过期“expired”
     * 
     * @see WxInviteStatus
     */
    @JsonProperty("invite_status")
    private String inviteStatus;
}