package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.component.api.entity
 * @Description: 授权相关信息
 * @date Date : 2019年04月25日 09:40
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class AuthorizeMsg extends BaseMsg {
    private static final long serialVersionUID = -2951489399205460828L;

    /**
     * 公众号或小程序appId
     */
    @JacksonXmlProperty(localName = "AuthorizerAppid")
    private String authorizerAppid;

    /**
     * 授权码
     */
    @JacksonXmlProperty(localName = "AuthorizationCode")
    private String authorizationCode;

    /**
     * 过期时间
     */
    @JacksonXmlProperty(localName = "AuthorizationCodeExpiredTime")
    private Long authorizationCodeExpiredTime;

    /**
     * 预授权码
     */
    @JacksonXmlProperty(localName = "PreAuthCode")
    private String preAuthCode;
}
