/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.msg;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title UpstreamMsgDistDto
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class UpstreamMsgDistDto implements Serializable {

    private static final long serialVersionUID = 9184988406541658882L;

    /**
     * 数据的日期，需在begin_date和end_date之间
     */
    @JsonAlias("ref_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date refDate;

    /**
     * 当日发送消息量分布的区间，0代表 “0”，1代表“1-5”，2代表“6-10”，3代表“10次以上”
     */
    @JsonAlias("count_interval")
    private int countInterval;

    /**
     * 上行发送了（向公众号发送了）消息的用户数
     */
    @JsonAlias("msg_user")
    private int msgUser;
}