/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.article;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title ArticleTotalDetail
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class ArticleTotalDetail implements Serializable {

    private static final long serialVersionUID = -3275443563885308343L;

    /**
     * 统计的日期，在getarticletotal接口中，ref_date指的是文章群发出日期， 而stat_date是数据统计日期
     */
    @JsonAlias("stat_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date statDate;

    /**
     * 送达人数，一般约等于总粉丝数（需排除黑名单或其他异常情况下无法收到消息的粉丝）
     */
    @JsonAlias("target_user")
    private int targetUser;

    /**
     * 图文页（点击群发图文卡片进入的页面）的阅读人数
     */
    @JsonAlias("int_page_read_user")
    private int intPageReadUser;

    /**
     * 图文页的阅读次数
     */
    @JsonAlias("int_page_read_count")
    private int intPageReadCount;

    /**
     * 原文页（点击图文页“阅读原文”进入的页面）的阅读人数，无原文页时此处数据为0
     */
    @JsonAlias("ori_page_read_user")
    private int oriPageReadUser;

    /**
     * 原文页的阅读次数
     */
    @JsonAlias("ori_page_read_count")
    private int oriPageReadCount;

    /**
     * 分享的人数
     */
    @JsonAlias("share_user")
    private int shareUser;

    /**
     * 分享的次数
     */
    @JsonAlias("share_count")
    private int shareCount;

    /**
     * 收藏的人数
     */
    @JsonAlias("add_to_fav_user")
    private int addToFavUser;

    /**
     * 收藏的次数
     */
    @JsonAlias("add_to_fav_count")
    private int addToFavCount;

    /**
     * 公众号会话阅读人数
     */
    @JsonAlias("int_page_from_session_read_user")
    private int intPageFromSessionReadUser;

    /**
     * 公众号会话阅读次数
     */
    @JsonAlias("int_page_from_session_read_count")
    private int intPageFromSessionReadCount;

    /**
     * 历史消息页阅读人数
     */
    @JsonAlias("int_page_from_hist_read_user")
    private int intPageFromHistMsgReadUser;

    /**
     * 历史消息页阅读次数
     */
    @JsonAlias("int_page_from_hist_read_count")
    private int intPageFromHistMsgReadCount;

    /**
     * 朋友圈阅读人数
     */
    @JsonAlias("int_page_from_feed_read_user")
    private int intPageFromFeedMsgReadUser;

    /**
     * 朋友圈阅读次数
     */
    @JsonAlias("int_page_from_feed_read_count")
    private int intPageFromFeedMsgReadCount;

    /**
     * 好友转发阅读人数
     */
    @JsonAlias("int_page_from_friends_read_user")
    private int intPageFromFriendsMsgReadUser;

    /**
     * 好友转发阅读次数
     */
    @JsonAlias("int_page_from_friends_read_count")
    private int intPageFromFriendsMsgReadCount;
    
    /**
     * 看一看来源阅读人数
     * 
     * @deprecated 公众号的接口页面中没有提到这个字段，但字段解释中有，不知道是否有用。
     */
    @Deprecated
    @JsonAlias("int_page_from_kanyikan_read_user")
    private int intPageFromKanyikanMsgReadUser;
    
    /**
     * 看一看来源阅读次数
     * 
     * @deprecated 公众号的接口页面中没有提到这个字段，但字段解释中有，不知道是否有用。
     */
    @JsonAlias("int_page_from_kanyikan_read_count")
    private int intPageFromKanyikanMsgReadCount;
    
    /**
     * 搜一搜来源阅读人数
     * 
     * @deprecated 公众号的接口页面中没有提到这个字段，但字段解释中有，不知道是否有用。
     */
    @JsonAlias("int_page_from_souyisou_read_user")
    private int intPageFromSouyisouMsgReadUser;
    
    /**
     * 搜一搜来源阅读次数
     * 
     * @deprecated 公众号的接口页面中没有提到这个字段，但字段解释中有，不知道是否有用。
     */
    @JsonAlias("int_page_from_souyishou_read_count")
    private int intPageFromSouyisouMsgReadCount;

    /**
     * 其他场景阅读人数
     */
    @JsonAlias("int_page_from_other_read_user")
    private int intPageFromOtherMsgReadUser;

    /**
     * 其他场景阅读次数
     */
    @JsonAlias("int_page_from_other_read_count")
    private int intPageFromOtherMsgReadCount;

    /**
     * 公众号会话转发朋友圈人数
     */
    @JsonAlias("feed_share_from_session_user")
    private int feedShareFromSessionUser;

    /**
     * 公众号会话转发朋友圈次数
     */
    @JsonAlias("feed_share_from_session_cnt")
    private int feedShareFromSessionCount;

    /**
     * 朋友圈转发朋友圈人数
     */
    @JsonAlias("feed_share_from_feed_user")
    private int feedShareFromFeedUser;

    /**
     * 朋友圈转发朋友圈次数
     */
    @JsonAlias("feed_share_from_feed_cnt")
    private int feedShareFromFeedCount;

    /**
     * 其他场景转发朋友圈人数
     */
    @JsonAlias("feed_share_from_other_user")
    private int feedShareFromOtherUser;

    /**
     * 其他场景转发朋友圈次数
     */
    @JsonAlias("feed_share_from_other_cnt")
    private int feedShareFromOtherCount;
}