/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.article;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title ArticleSummaryDto
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class ArticleSummaryDto implements Serializable {

    private static final long serialVersionUID = 4787847141583931800L;

    /**
     * 数据的日期，需在begin_date和end_date之间
     */
    @JsonAlias("ref_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date refDate;

    /**
     * 请注意：这里的msgid实际上是由msgid（图文消息id，这也就是群发接口调用后返回的msg_data_id）和index（消息次序索引）组成， 例如12003_3， 其中12003是msgid，即一次群发的消息的id； 3为index，假设该次群发的图文消息共5个文章（因为可能为多图文），3表示5个中的第3个
     */
    @JsonAlias("msgid")
    private String msgId;

    /**
     * 代表用户从哪里进入来阅读该图文。
     *
     * 0:会话;1.好友;2.朋友圈;3.腾讯微博;4.历史消息页;5.其他;6.看一看;7.搜一搜
     */
    @JsonAlias("user_source")
    private int userSource;

    /**
     * 图文消息的标题
     */
    private String title;

    /**
     * 图文页（点击群发图文卡片进入的页面）的阅读人数
     */
    @JsonAlias("int_page_read_user")
    private int intPageReadUser;

    /**
     * 图文页的阅读次数
     */
    @JsonAlias("int_page_read_count")
    private int intPageReadCount;

    /**
     * 原文页（点击图文页“阅读原文”进入的页面）的阅读人数，无原文页时此处数据为0
     */
    @JsonAlias("ori_page_read_user")
    private int oriPageReadUser;

    /**
     * 原文页的阅读次数
     */
    @JsonAlias("ori_page_read_count")
    private int oriPageReadCount;

    /**
     * 分享的人数
     */
    @JsonAlias("share_user")
    private int shareUser;

    /**
     * 分享的次数
     */
    @JsonAlias("share_count")
    private int shareCount;

    /**
     * 收藏的人数
     */
    @JsonAlias("add_to_fav_user")
    private int addToFavUser;

    /**
     * 收藏的次数
     */
    @JsonAlias("add_to_fav_count")
    private int addToFavCount;
}