package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.fund;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 7:44 下午
 */
@Data
public class OrderFlowDto {

    /**
     * 订单号
     */
    @JsonAlias("order_id")
    private Long orderId;

    /**
     * 资金状态
     *
     * 枚举值	描述	string 映射
     * 1	交易失败	ORDER_FLOW_STATUS_TRANSACTION_FAIL
     * 2	交易成功	ORDER_FLOW_STATUS_TRANSACTION_SUC
     * 3	交易异常	ORDER_FLOW_STATUS_TRANSACTION_ERR
     * 4	待结算	ORDER_FLOW_STATUS_TRANSACTION_PENDING_SETTLED
     */
    private String status;

    /**
     * 商家所得金额
     */
    private Long price;

    /**
     * 订单总金额
     */
    @JsonAlias("order_price")
    private Long orderPrice;

    /**
     * 打折金额
     */
    @JsonAlias("discount_fee")
    private Long discountFee;

    /**
     * 服务费
     */
    @JsonAlias("service_fee")
    private Long serviceFee;

    /**
     * 手续费
     */
    @JsonAlias("handling_fee")
    private Long handlingFee;

    /**
     * 退款金额
     */
    @JsonAlias("refund_fee")
    private Long refundFee;

    /**
     * 结算时间
     */
    @JsonAlias("settled_time")
    private Long settledTime;

    /**
     * 下单时间
     */
    @JsonAlias("order_time")
    private Long orderTime;

    /**
     * 退款类型
     */
    @JsonAlias("refunding_type")
    private Integer refundingType;
}
