package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 5:29 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class CouponCodeInfo {

    /**
     * 0-每天都能核销 1-节假日不可用。该字段只在核销页面用作展示，不会限制核销流程，由商家自行决定是否核销。
     */
    @JsonProperty("verify_type")
    private Integer verifyType;

    /**
     * 核销详情
     */
    @JsonProperty("valid_info")
    private ValidInfoByCreate validInfo;

    /**
     * 订单列表 返回的内容
     * 电子兑换类型商品
     * 下单时 预留的手机号
     */
    @JsonAlias("phone_number")
    private String phoneNumber;

    @JsonAlias("verifier_nickname")
    private String verifierNickname;

    @JsonAlias("verify_time")
    private Long verifyTime;
}
