package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 4:59 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class CategoryLevelDto {

    /**
     * 类目ID，如果brand_id=2100000000，需要先通过获取类目接口category/get拿到可用的cat_id；如果brand_id!=2100000000，则这里的cat_id需要与获取品牌接口brand/get中的1,2,3级类目一一对应
     */
    @JsonProperty("cat_id")
    private Long catId;

    /**
     * 类目层级
     */
    @JsonProperty("level")
    private Integer level;

    /**
     * 类目名称,非微信要求,内部返回参数使用
     */
    private String name;
}
