package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/19 11:49 上午
 */
@Data
public class LatestAuditStatusResp extends ErrorCode {

    /**
     * 最新的审核 ID
     */
    @JsonProperty("auditid")
    private String auditId;

    /**
     * 审核状态
     * <p>
     * 状态值	说明
     * 0	审核成功
     * 1	审核被拒绝
     * 2	审核中
     * 3	已撤回
     */
    private Integer status;

    /**
     * 当审核被拒绝时，返回的拒绝原因
     */
    private String reason;

    /**
     * 当审核被拒绝时，会返回审核失败的小程序截图示例。用 | 分隔的 media_id 的列表，可通过获取永久素材接口拉取截图内容
     */
    @JsonProperty("ScreenShot")
    private String screenShot;

}
