/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 语音消息
 * 
 * @title VoiceReqMsg
 * @desc 语音消息
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper=true)
public class VoiceReqMsg extends BaseReqMsg {

    private static final long serialVersionUID = -1449838509177852987L;

    /**
     * 语音消息媒体id，可以调用获取临时素材接口拉取数据。
     */
    @JacksonXmlProperty(localName = "MediaId")
    @JsonProperty("media_id")
    private String mediaId;

    /**
     * 语音格式，如amr，speex等
     */
    @JacksonXmlProperty(localName = "Format")
    private String format;

    /**
     * 请注意，开通语音识别后，用户每次发送语音给公众号时，微信会在推送的语音消息XML数据包中，增加一个Recognition字段（注：由于客户端缓存，开发者开启或者关闭语音识别功能，对新关注者立刻生效，对已关注用户需要24小时生效。开发者可以重新关注此帐号进行测试）。
     */
    @JacksonXmlProperty(localName = "Recognition")
    private String recognition;
}