package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName PicWeiXinEvent
 * @Description pic_weixin：弹出微信相册发图器的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 10:38
 * @Version 1.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PicWeiXinEvent extends BaseEvent {
    private static final long serialVersionUID = 6561803261182625277L;

    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 发送的图片信息
     */
    @JacksonXmlProperty(localName = "SendPicsInfo")
    private SendPicsInfo sendPicsInfo;
}
